
document.addEventListener("keypress", function (event)
{
	if (event.metaKey && event.shiftKey && !event.altKey && String.fromCharCode(event.keyCode).toLowerCase()=="c")
	{
		clip();
		event.stopPropagation();
		event.preventDefault();
	}
}, false);

/* document.addEventListener("contextmenu", handleContextMenu, false);
function handleContextMenu(event)
{
    var selectedText = window.getSelection().toString();
    safari.extension.setContextMenuEventUserInfo(event,
        { "selectedText": selectedText });
} */

safari.self.addEventListener("message", handleMessage);
function handleMessage(event)
{
	if (event.name=="clip" && window.top===window) // Only main frame should send the response
		clip();
}

function clip()
{
    var selectedText = window.getSelection().toString(), referrer = document.referrer, width = window.innerWidth, source = document.documentElement.outerHTML, encoding = document.characterSet;
	var userInfo = {"selectedText": selectedText, "referrer": referrer, "width": width, "source": source, "encoding": encoding };
	safari.extension.dispatchMessage("clip",userInfo);
}
